/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jwi;

import edu.mit.jwi.DataSourceDictionary;
import edu.mit.jwi.IDictionary;
import edu.mit.jwi.IRAMDictionary;
import edu.mit.jwi.data.FileProvider;
import edu.mit.jwi.data.IHasLifecycle;
import edu.mit.jwi.item.ExceptionEntryID;
import edu.mit.jwi.item.IExceptionEntry;
import edu.mit.jwi.item.IExceptionEntryID;
import edu.mit.jwi.item.IHasPOS;
import edu.mit.jwi.item.IIndexWord;
import edu.mit.jwi.item.IIndexWordID;
import edu.mit.jwi.item.IPointer;
import edu.mit.jwi.item.ISenseEntry;
import edu.mit.jwi.item.ISenseKey;
import edu.mit.jwi.item.ISynset;
import edu.mit.jwi.item.ISynsetID;
import edu.mit.jwi.item.IVerbFrame;
import edu.mit.jwi.item.IVersion;
import edu.mit.jwi.item.IWord;
import edu.mit.jwi.item.IWordID;
import edu.mit.jwi.item.IndexWord;
import edu.mit.jwi.item.IndexWordID;
import edu.mit.jwi.item.POS;
import edu.mit.jwi.item.SenseEntry;
import edu.mit.jwi.item.Synset;
import edu.mit.jwi.item.Word;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RAMDictionary
implements IRAMDictionary {
    public static int defaultLoadPolicy = 4;
    protected final IDictionary backing;
    protected final IRAMDictionary.IInputStreamFactory factory;
    protected final Lock lifecycleLock = new ReentrantLock();
    protected final Lock loadLock = new ReentrantLock();
    protected volatile IHasLifecycle.LifecycleState state = IHasLifecycle.LifecycleState.CLOSED;
    protected transient Thread loader;
    protected int loadPolicy;
    protected DictionaryData data;

    public RAMDictionary(File file) {
        this(file, defaultLoadPolicy);
    }

    public RAMDictionary(URL url) {
        this(url, defaultLoadPolicy);
    }

    public RAMDictionary(File file, int loadPolicy) {
        this(RAMDictionary.createBackingDictionary(file), RAMDictionary.createInputStreamFactory(file), loadPolicy);
    }

    public RAMDictionary(URL url, int loadPolicy) {
        this(RAMDictionary.createBackingDictionary(url), RAMDictionary.createInputStreamFactory(url), loadPolicy);
    }

    public RAMDictionary(IDictionary dict, int loadPolicy) {
        this(dict, null, loadPolicy);
    }

    public RAMDictionary(IRAMDictionary.IInputStreamFactory factory) {
        this(null, factory, 8);
    }

    protected RAMDictionary(IDictionary backing, IRAMDictionary.IInputStreamFactory factory, int loadPolicy) {
        if (backing == null && factory == null) {
            throw new NullPointerException();
        }
        if (backing != null && factory != null) {
            throw new IllegalStateException("Both backing dictionary and input stream factory may not be non-null");
        }
        this.backing = backing;
        this.factory = factory;
        this.loadPolicy = factory == null ? loadPolicy : 8;
    }

    public IDictionary getBackingDictionary() {
        return this.backing;
    }

    public IRAMDictionary.IInputStreamFactory getStreamFactory() {
        return this.factory;
    }

    @Override
    public void setCharset(Charset charset) {
        if (this.isOpen()) {
            throw new IHasLifecycle.ObjectOpenException();
        }
        this.backing.setCharset(charset);
    }

    @Override
    public Charset getCharset() {
        return this.backing == null ? null : this.backing.getCharset();
    }

    @Override
    public int getLoadPolicy() {
        return this.loadPolicy;
    }

    @Override
    public void setLoadPolicy(int policy) {
        if (this.isOpen()) {
            throw new IHasLifecycle.ObjectOpenException();
        }
        this.loadPolicy = this.factory == null ? policy : 8;
    }

    @Override
    public boolean isLoaded() {
        return this.data != null;
    }

    @Override
    public void load() {
        try {
            this.load(false);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(boolean block) throws InterruptedException {
        if (this.loader != null) {
            return;
        }
        try {
            this.loadLock.lock();
            if (this.state == IHasLifecycle.LifecycleState.CLOSED || this.state == IHasLifecycle.LifecycleState.CLOSING) {
                return;
            }
            if (this.loader != null) {
                return;
            }
            this.loader = new Thread(new JWIBackgroundDataLoader());
            this.loader.setName(JWIBackgroundDataLoader.class.getSimpleName());
            this.loader.setDaemon(true);
            this.loader.start();
            if (block) {
                this.loader.join();
            }
        }
        finally {
            this.loadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean open() throws IOException {
        try {
            this.lifecycleLock.lock();
            if (this.state == IHasLifecycle.LifecycleState.OPEN) {
                boolean bl = true;
                return bl;
            }
            if (this.state != IHasLifecycle.LifecycleState.CLOSED) {
                boolean bl = false;
                return bl;
            }
            this.state = IHasLifecycle.LifecycleState.OPENING;
            if (this.backing == null) {
                try {
                    this.load(true);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    boolean bl = false;
                    this.state = this.assertLifecycleState();
                    this.lifecycleLock.unlock();
                    return bl;
                }
                boolean e = true;
                return e;
            }
            boolean result = this.backing.open();
            if (result) {
                try {
                    switch (this.loadPolicy) {
                        case 8: {
                            this.load(true);
                            break;
                        }
                        case 4: {
                            this.load(false);
                        }
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    boolean bl = false;
                    this.state = this.assertLifecycleState();
                    this.lifecycleLock.unlock();
                    return bl;
                }
            }
            boolean bl = result;
            return bl;
        }
        finally {
            this.state = this.assertLifecycleState();
            this.lifecycleLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOpen() {
        try {
            this.lifecycleLock.lock();
            boolean bl = this.state == IHasLifecycle.LifecycleState.OPEN;
            return bl;
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this.lifecycleLock.lock();
            if (this.state == IHasLifecycle.LifecycleState.CLOSED) {
                return;
            }
            if (this.state != IHasLifecycle.LifecycleState.CLOSING) {
                return;
            }
            this.state = IHasLifecycle.LifecycleState.CLOSING;
            if (this.loader != null) {
                this.loader.interrupt();
                try {
                    this.loader.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.loader = null;
            }
            if (this.backing != null) {
                this.backing.close();
            }
            this.data = null;
        }
        finally {
            this.state = this.assertLifecycleState();
            this.lifecycleLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final IHasLifecycle.LifecycleState assertLifecycleState() {
        try {
            this.lifecycleLock.lock();
            if (this.data != null) {
                IHasLifecycle.LifecycleState lifecycleState = IHasLifecycle.LifecycleState.OPEN;
                return lifecycleState;
            }
            if (this.backing != null && this.backing.isOpen()) {
                IHasLifecycle.LifecycleState lifecycleState = IHasLifecycle.LifecycleState.OPEN;
                return lifecycleState;
            }
            IHasLifecycle.LifecycleState lifecycleState = IHasLifecycle.LifecycleState.CLOSED;
            return lifecycleState;
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void export(OutputStream out) throws IOException {
        try {
            this.loadLock.lock();
            if (!this.isLoaded()) {
                throw new IllegalStateException("RAMDictionary not loaded into memory");
            }
            out = new GZIPOutputStream(out);
            out = new BufferedOutputStream(out);
            ObjectOutputStream oos = new ObjectOutputStream(out);
            oos.writeObject(this.data);
            oos.flush();
            oos.close();
        }
        finally {
            this.loadLock.unlock();
        }
    }

    @Override
    public IVersion getVersion() {
        if (this.backing != null) {
            return this.backing.getVersion();
        }
        if (this.data != null) {
            return this.data.version;
        }
        return null;
    }

    @Override
    public IIndexWord getIndexWord(String lemma, POS pos) {
        return this.getIndexWord(new IndexWordID(lemma, pos));
    }

    @Override
    public IIndexWord getIndexWord(IIndexWordID id) {
        if (this.data != null) {
            return this.data.idxWords.get((Object)id.getPOS()).get(id);
        }
        return this.backing.getIndexWord(id);
    }

    @Override
    public Iterator<IIndexWord> getIndexWordIterator(POS pos) {
        return new HotSwappableIndexWordIterator(pos);
    }

    @Override
    public IWord getWord(IWordID id) {
        if (this.data != null) {
            ISynset synset = this.data.synsets.get((Object)id.getPOS()).get(id.getSynsetID());
            if (synset == null) {
                return null;
            }
            if (id.getWordNumber() > 0) {
                return synset.getWord(id.getWordNumber());
            }
            if (id.getLemma() != null) {
                for (IWord word : synset.getWords()) {
                    if (!word.getLemma().equalsIgnoreCase(id.getLemma())) continue;
                    return word;
                }
                return null;
            }
            throw new IllegalArgumentException("Not enough information in IWordID instance to retrieve word.");
        }
        return this.backing.getWord(id);
    }

    @Override
    public IWord getWord(ISenseKey key) {
        if (this.data != null) {
            return this.data.words.get(key);
        }
        return this.backing.getWord(key);
    }

    @Override
    public ISynset getSynset(ISynsetID id) {
        if (this.data != null) {
            return this.data.synsets.get((Object)id.getPOS()).get(id);
        }
        return this.backing.getSynset(id);
    }

    @Override
    public Iterator<ISynset> getSynsetIterator(POS pos) {
        return new HotSwappableSynsetIterator(pos);
    }

    @Override
    public ISenseEntry getSenseEntry(ISenseKey key) {
        if (this.data != null) {
            return this.data.senses.get(key);
        }
        return this.backing.getSenseEntry(key);
    }

    @Override
    public Iterator<ISenseEntry> getSenseEntryIterator() {
        return new HotSwappableSenseEntryIterator();
    }

    @Override
    public IExceptionEntry getExceptionEntry(String surfaceForm, POS pos) {
        return this.getExceptionEntry(new ExceptionEntryID(surfaceForm, pos));
    }

    @Override
    public IExceptionEntry getExceptionEntry(IExceptionEntryID id) {
        if (this.data != null) {
            return this.data.exceptions.get((Object)id.getPOS()).get(id);
        }
        return this.backing.getExceptionEntry(id);
    }

    @Override
    public Iterator<IExceptionEntry> getExceptionEntryIterator(POS pos) {
        return new HotSwappableExceptionEntryIterator(pos);
    }

    public static IRAMDictionary.IInputStreamFactory createInputStreamFactory(File file) {
        return FileProvider.isLocalDirectory(file) ? null : new IRAMDictionary.FileInputStreamFactory(file);
    }

    public static IRAMDictionary.IInputStreamFactory createInputStreamFactory(URL url) {
        return FileProvider.isLocalDirectory(url) ? null : new IRAMDictionary.URLInputStreamFactory(url);
    }

    public static IDictionary createBackingDictionary(File file) {
        return FileProvider.isLocalDirectory(file) ? new DataSourceDictionary(new FileProvider(file)) : null;
    }

    public static IDictionary createBackingDictionary(URL url) {
        return FileProvider.isLocalDirectory(url) ? new DataSourceDictionary(new FileProvider(url)) : null;
    }

    public static boolean export(File in, OutputStream out) throws IOException {
        return RAMDictionary.export(new RAMDictionary(in, 8), out);
    }

    public static boolean export(URL in, OutputStream out) throws IOException {
        return RAMDictionary.export(new RAMDictionary(in, 8), out);
    }

    public static boolean export(IRAMDictionary.IInputStreamFactory in, OutputStream out) throws IOException {
        return RAMDictionary.export(new RAMDictionary(in), out);
    }

    protected static boolean export(IRAMDictionary dict, OutputStream out) throws IOException {
        System.out.print("Performing load...");
        dict.open();
        System.out.println("(done)");
        System.out.print("Performing export...");
        dict.export(out);
        dict.close();
        dict = null;
        System.gc();
        System.out.println("(done)");
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DictionaryData
    implements Serializable {
        private static final long serialVersionUID = 240L;
        protected IVersion version;
        protected Map<POS, Map<IIndexWordID, IIndexWord>> idxWords = this.makePOSMap();
        protected Map<POS, Map<ISynsetID, ISynset>> synsets = this.makePOSMap();
        protected Map<POS, Map<IExceptionEntryID, IExceptionEntry>> exceptions = this.makePOSMap();
        protected Map<ISenseKey, IWord> words = this.makeMap(208000, null);
        protected Map<ISenseKey, ISenseEntry> senses = this.makeMap(208000, null);

        protected <K, V> Map<POS, Map<K, V>> makePOSMap() {
            HashMap<POS, Map<POS, Map<K, V>>> result = new HashMap<POS, Map<POS, Map<K, V>>>(POS.values().length);
            for (POS pos : POS.values()) {
                result.put(pos, this.makeMap(4096, null));
            }
            return result;
        }

        protected <K, V> Map<K, V> makeMap(int initialSize, Map<K, V> contents) {
            return contents == null ? new LinkedHashMap(initialSize) : new LinkedHashMap<K, V>(contents);
        }

        public void compact() {
            this.compactSize();
            this.compactObjects();
        }

        public void compactSize() {
            this.compactPOSMap(this.idxWords);
            this.compactPOSMap(this.synsets);
            this.compactPOSMap(this.exceptions);
            this.words = this.compactMap(this.words);
            this.senses = this.compactMap(this.senses);
        }

        protected <K, V> void compactPOSMap(Map<POS, Map<K, V>> map) {
            for (Map.Entry<POS, Map<K, Map<K, V>>> entry : map.entrySet()) {
                entry.setValue(this.compactMap(entry.getValue()));
            }
        }

        protected <K, V> Map<K, V> compactMap(Map<K, V> map) {
            if (map == null) {
                throw new NullPointerException();
            }
            return this.makeMap(-1, map);
        }

        public void compactObjects() {
            for (POS pos : POS.values()) {
                for (Map.Entry<ISynsetID, ISynset> entry : this.synsets.get((Object)pos).entrySet()) {
                    entry.setValue(this.makeSynset(entry.getValue()));
                }
                for (Map.Entry<IHasPOS, IHasPOS> entry : this.idxWords.get((Object)pos).entrySet()) {
                    entry.setValue(this.makeIndexWord((IIndexWord)entry.getValue()));
                }
            }
        }

        protected ISynset makeSynset(ISynset old) {
            Map<IPointer, List<ISynsetID>> oldIDs = old.getRelatedMap();
            HashMap newIDs = new HashMap(oldIDs.size());
            for (Map.Entry<IPointer, List<ISynsetID>> entry : oldIDs.entrySet()) {
                ArrayList newList = new ArrayList(entry.getValue().size());
                for (ISynsetID otherID : entry.getValue()) {
                    ISynset otherSynset = this.synsets.get((Object)otherID.getPOS()).get(otherID);
                    newList.add(otherSynset.getID());
                }
                newIDs.put(entry.getKey(), newList);
            }
            List<IWord> oldWords = old.getWords();
            ArrayList<Synset.IWordBuilder> newWords = new ArrayList<Synset.IWordBuilder>(oldWords.size());
            for (IWord oldWord : old.getWords()) {
                newWords.add(new WordBuilder(old, oldWord));
            }
            return new Synset((ISynsetID)old.getID(), old.getLexicalFile(), old.isAdjectiveSatellite(), old.isAdjectiveHead(), old.getGloss(), newWords, newIDs);
        }

        protected IWord makeWord(ISynset newSynset, ISynset oldSynset, IWord old) {
            Map<IPointer, List<IWordID>> oldPtrs = old.getRelatedMap();
            HashMap newPtrs = new HashMap(oldPtrs.size());
            for (Map.Entry<IPointer, List<IWordID>> entry : oldPtrs.entrySet()) {
                ArrayList newList = new ArrayList(entry.getValue().size());
                for (IWordID otherID : entry.getValue()) {
                    ISynset otherSynset = this.synsets.get((Object)otherID.getPOS()).get(otherID.getSynsetID());
                    newList.add(otherSynset.getWord(otherID.getWordNumber()).getID());
                }
                newPtrs.put(entry.getKey(), newList);
            }
            Word word = new Word(newSynset, (IWordID)old.getID(), old.getLexicalID(), old.getAdjectiveMarker(), old.getVerbFrames(), newPtrs);
            ISenseKey key = word.getSenseKey();
            if (key.needsHeadSet()) {
                ISenseKey oldKey = old.getSenseKey();
                key.setHead(oldKey.getHeadWord(), oldKey.getHeadID());
            }
            return word;
        }

        protected IIndexWord makeIndexWord(IIndexWord old) {
            List<IWordID> oldIDs = old.getWordIDs();
            IWordID[] newIDs = new IWordID[oldIDs.size()];
            for (int i = 0; i < oldIDs.size(); ++i) {
                IWordID oldID = oldIDs.get(i);
                ISynset synset = this.synsets.get((Object)oldID.getPOS()).get(oldID.getSynsetID());
                for (IWord newWord : synset.getWords()) {
                    if (!((IWordID)newWord.getID()).equals(oldID)) continue;
                    newIDs[i] = (IWordID)newWord.getID();
                    break;
                }
                if (newIDs[i] != null) continue;
                throw new IllegalStateException();
            }
            return new IndexWord((IIndexWordID)old.getID(), old.getTagSenseCount(), newIDs);
        }

        public class WordBuilder
        implements Synset.IWordBuilder {
            private final ISynset oldSynset;
            private final IWord oldWord;

            public WordBuilder(ISynset oldSynset, IWord oldWord) {
                if (oldSynset == null) {
                    throw new NullPointerException();
                }
                if (oldWord == null) {
                    throw new NullPointerException();
                }
                this.oldSynset = oldSynset;
                this.oldWord = oldWord;
            }

            public IWord toWord(ISynset synset) {
                return DictionaryData.this.makeWord(synset, this.oldSynset, this.oldWord);
            }

            public void addVerbFrame(IVerbFrame frame) {
                throw new UnsupportedOperationException();
            }

            public void addRelatedWord(IPointer type, IWordID id) {
                throw new UnsupportedOperationException();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DataLoader
    implements Callable<DictionaryData> {
        private final IDictionary source;

        public DataLoader(IDictionary source) {
            if (source == null) {
                throw new NullPointerException();
            }
            this.source = source;
        }

        @Override
        public DictionaryData call() throws Exception {
            DictionaryData result = new DictionaryData();
            result.version = this.source.getVersion();
            Thread t = Thread.currentThread();
            for (POS pos : POS.values()) {
                Map<IIndexWordID, IIndexWord> idxWords = result.idxWords.get((Object)pos);
                Iterator<IHasPOS> i = this.source.getIndexWordIterator(pos);
                while (i.hasNext()) {
                    IIndexWord idxWord = i.next();
                    idxWords.put((IIndexWordID)idxWord.getID(), idxWord);
                }
                if (t.isInterrupted()) {
                    return null;
                }
                Map<ISynsetID, ISynset> synsets = result.synsets.get((Object)pos);
                i = this.source.getSynsetIterator(pos);
                while (i.hasNext()) {
                    ISynset synset = (ISynset)i.next();
                    synsets.put((ISynsetID)synset.getID(), synset);
                    for (IWord word : synset.getWords()) {
                        result.words.put(word.getSenseKey(), word);
                    }
                }
                if (t.isInterrupted()) {
                    return null;
                }
                Map<IExceptionEntryID, IExceptionEntry> exceptions = result.exceptions.get((Object)pos);
                i = this.source.getExceptionEntryIterator(pos);
                while (i.hasNext()) {
                    IExceptionEntry exception = (IExceptionEntry)i.next();
                    exceptions.put((IExceptionEntryID)exception.getID(), exception);
                }
                if (!t.isInterrupted()) continue;
                return null;
            }
            Iterator<ISenseEntry> i = this.source.getSenseEntryIterator();
            while (i.hasNext()) {
                ISenseEntry entry = i.next();
                IWord word = result.words.get(entry.getSenseKey());
                if (word == null) {
                    throw new NullPointerException();
                }
                result.senses.put(word.getSenseKey(), this.makeSenseEntry(word.getSenseKey(), entry));
            }
            if (t.isInterrupted()) {
                return null;
            }
            result.compactSize();
            if (t.isInterrupted()) {
                return null;
            }
            result.compactObjects();
            if (t.isInterrupted()) {
                return null;
            }
            return result;
        }

        protected ISenseEntry makeSenseEntry(ISenseKey key, ISenseEntry old) {
            return new SenseEntry(key, old.getOffset(), old.getSenseNumber(), old.getTagCount());
        }
    }

    protected class JWIBackgroundDataLoader
    implements Runnable {
        protected JWIBackgroundDataLoader() {
        }

        public void run() {
            block4: {
                try {
                    if (RAMDictionary.this.backing == null) {
                        InputStream in = RAMDictionary.this.factory.makeInputStream();
                        in = new GZIPInputStream(in);
                        in = new BufferedInputStream(in);
                        ObjectInputStream ois = new ObjectInputStream(in);
                        RAMDictionary.this.data = (DictionaryData)ois.readObject();
                        in.close();
                    } else {
                        DataLoader loader = new DataLoader(RAMDictionary.this.backing);
                        RAMDictionary.this.data = loader.call();
                        RAMDictionary.this.backing.close();
                    }
                }
                catch (Throwable t) {
                    if (Thread.currentThread().isInterrupted()) break block4;
                    t.printStackTrace();
                    System.err.println("Unable to load dictionary data into memory");
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class HotSwappableSenseEntryIterator
    extends HotSwappableIterator<ISenseEntry> {
        public HotSwappableSenseEntryIterator() {
            super(RAMDictionary.this.data == null ? RAMDictionary.this.backing.getSenseEntryIterator() : RAMDictionary.this.data.senses.values().iterator(), RAMDictionary.this.data == null);
        }

        @Override
        protected Iterator<ISenseEntry> makeIterator() {
            return RAMDictionary.this.data.senses.values().iterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class HotSwappableExceptionEntryIterator
    extends HotSwappableIterator<IExceptionEntry> {
        private final POS pos;

        public HotSwappableExceptionEntryIterator(POS pos) {
            super(RAMDictionary.this.data == null ? RAMDictionary.this.backing.getExceptionEntryIterator(pos) : RAMDictionary.this.data.exceptions.get((Object)pos).values().iterator(), RAMDictionary.this.data == null);
            this.pos = pos;
        }

        @Override
        protected Iterator<IExceptionEntry> makeIterator() {
            return RAMDictionary.this.data.exceptions.get((Object)this.pos).values().iterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class HotSwappableSynsetIterator
    extends HotSwappableIterator<ISynset> {
        private final POS pos;

        public HotSwappableSynsetIterator(POS pos) {
            super(RAMDictionary.this.data == null ? RAMDictionary.this.backing.getSynsetIterator(pos) : RAMDictionary.this.data.synsets.get((Object)pos).values().iterator(), RAMDictionary.this.data == null);
            this.pos = pos;
        }

        @Override
        protected Iterator<ISynset> makeIterator() {
            return RAMDictionary.this.data.synsets.get((Object)this.pos).values().iterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class HotSwappableIndexWordIterator
    extends HotSwappableIterator<IIndexWord> {
        private final POS pos;

        public HotSwappableIndexWordIterator(POS pos) {
            super(RAMDictionary.this.data == null ? RAMDictionary.this.backing.getIndexWordIterator(pos) : RAMDictionary.this.data.idxWords.get((Object)pos).values().iterator(), RAMDictionary.this.data == null);
            this.pos = pos;
        }

        @Override
        protected Iterator<IIndexWord> makeIterator() {
            return RAMDictionary.this.data.idxWords.get((Object)this.pos).values().iterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class HotSwappableIterator<E>
    implements Iterator<E> {
        private Iterator<E> itr;
        private boolean checkForLoad;
        private E last = null;

        public HotSwappableIterator(Iterator<E> itr, boolean checkForLoad) {
            if (itr == null) {
                throw new NullPointerException();
            }
            this.itr = itr;
            this.checkForLoad = checkForLoad;
        }

        @Override
        public boolean hasNext() {
            if (this.checkForLoad) {
                this.checkForLoad();
            }
            return this.itr.hasNext();
        }

        @Override
        public E next() {
            if (this.checkForLoad) {
                this.checkForLoad();
                this.last = this.itr.next();
                return this.last;
            }
            return this.itr.next();
        }

        protected void checkForLoad() {
            if (RAMDictionary.this.data == null) {
                return;
            }
            this.checkForLoad = false;
            this.itr = this.makeIterator();
            if (this.last != null) {
                while (this.itr.hasNext()) {
                    E consume = this.itr.next();
                    if (!this.last.equals(consume)) continue;
                    return;
                }
                throw new IllegalStateException();
            }
        }

        protected abstract Iterator<E> makeIterator();

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

