/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jwi.data;

import edu.mit.jwi.data.IContentType;
import edu.mit.jwi.data.WordnetFile;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinarySearchWordnetFile<T>
extends WordnetFile<T> {
    protected final Comparator<String> fComparator = this.getContentType().getLineComparator();

    public BinarySearchWordnetFile(File file, IContentType<T> contentType) {
        super(file, contentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLine(String key) {
        ByteBuffer buffer;
        ByteBuffer byteBuffer = buffer = this.getBuffer();
        synchronized (byteBuffer) {
            int start = 0;
            int midpoint = -1;
            int stop = buffer.limit();
            while (stop - start > 1) {
                int cmp;
                midpoint = (start + stop) / 2;
                buffer.position(midpoint);
                BinarySearchWordnetFile.rewindToLineStart(buffer);
                String line = BinarySearchWordnetFile.getLine(buffer, this.getContentType().getCharset());
                int n = cmp = line == null ? 1 : this.fComparator.compare(line, key);
                if (cmp == 0) {
                    return line;
                }
                if (cmp > 0) {
                    stop = midpoint;
                    continue;
                }
                start = midpoint;
            }
        }
        return null;
    }

    @Override
    public WordnetFile.LineIterator makeIterator(ByteBuffer buffer, String key) {
        return new BinarySearchLineIterator(buffer, key);
    }

    public class BinarySearchLineIterator
    extends WordnetFile.LineIterator {
        public BinarySearchLineIterator(ByteBuffer buffer, String key) {
            super(BinarySearchWordnetFile.this, buffer, key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void findFirstLine(String key) {
            ByteBuffer byteBuffer = this.itrBuffer;
            synchronized (byteBuffer) {
                int lastOffset = -1;
                int start = 0;
                int stop = this.itrBuffer.limit();
                int midpoint = -1;
                while (start + 1 < stop) {
                    midpoint = (start + stop) / 2;
                    this.itrBuffer.position(midpoint);
                    String line = WordnetFile.getLine(this.itrBuffer, BinarySearchWordnetFile.this.getContentType().getCharset());
                    int offset = this.itrBuffer.position();
                    line = WordnetFile.getLine(this.itrBuffer, BinarySearchWordnetFile.this.getContentType().getCharset());
                    if (line == null) {
                        this.itrBuffer.position(this.itrBuffer.limit());
                        return;
                    }
                    int compare = BinarySearchWordnetFile.this.fComparator.compare(line, key);
                    if (compare == 0) {
                        this.next = line;
                        return;
                    }
                    if (compare > 0) {
                        stop = midpoint;
                    } else {
                        start = midpoint;
                    }
                    if (!line.startsWith(key)) continue;
                    lastOffset = offset;
                }
                if (lastOffset > -1) {
                    this.itrBuffer.position(lastOffset);
                    this.next = WordnetFile.getLine(this.itrBuffer, BinarySearchWordnetFile.this.getContentType().getCharset());
                    return;
                }
                this.itrBuffer.position(this.itrBuffer.limit());
            }
        }
    }
}

