/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jwi.data;

import edu.mit.jwi.data.IDataType;
import edu.mit.jwi.data.parse.DataLineParser;
import edu.mit.jwi.data.parse.ExceptionLineParser;
import edu.mit.jwi.data.parse.ILineParser;
import edu.mit.jwi.data.parse.IndexLineParser;
import edu.mit.jwi.data.parse.SenseLineParser;
import edu.mit.jwi.item.IExceptionEntryProxy;
import edu.mit.jwi.item.IIndexWord;
import edu.mit.jwi.item.ISenseEntry;
import edu.mit.jwi.item.ISynset;
import edu.mit.jwi.item.POS;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataType<T>
implements IDataType<T> {
    public static final DataType<IIndexWord> INDEX = new DataType<IIndexWord>("Index", true, IndexLineParser.getInstance(), "index", "idx");
    public static final DataType<ISynset> DATA = new DataType<ISynset>("Data", true, DataLineParser.getInstance(), "data", "dat");
    public static final DataType<IExceptionEntryProxy> EXCEPTION = new DataType<IExceptionEntryProxy>("Exception", false, ExceptionLineParser.getInstance(), "exception", "exc");
    public static final DataType<ISenseEntry> SENSE = new DataType<ISenseEntry>("Sense", false, SenseLineParser.getInstance(), "sense");
    private final String name;
    private final Set<String> hints;
    private final boolean hasVersion;
    private final ILineParser<T> parser;
    private static Set<DataType<?>> dataTypes = null;

    public DataType(String userFriendlyName, boolean hasVersion, ILineParser<T> parser, String ... hints) {
        this(userFriendlyName, hasVersion, parser, hints == null ? null : Arrays.asList(hints));
    }

    public DataType(String userFriendlyName, boolean hasVersion, ILineParser<T> parser, Collection<String> hints) {
        if (parser == null) {
            throw new NullPointerException();
        }
        this.name = userFriendlyName;
        this.parser = parser;
        this.hasVersion = hasVersion;
        this.hints = hints == null || hints.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<String>(hints));
    }

    @Override
    public boolean hasVersion() {
        return this.hasVersion;
    }

    @Override
    public Set<String> getResourceNameHints() {
        return this.hints;
    }

    @Override
    public ILineParser<T> getParser() {
        return this.parser;
    }

    public String toString() {
        return this.name;
    }

    public static Collection<DataType<?>> values() {
        if (dataTypes == null) {
            Field[] fields = DataType.class.getFields();
            ArrayList<Field> instanceFields = new ArrayList<Field>();
            for (Field field : fields) {
                if (field.getGenericType() != DataType.class) continue;
                instanceFields.add(field);
            }
            LinkedHashSet<DataType> hidden = new LinkedHashSet<DataType>(instanceFields.size());
            for (Field field : instanceFields) {
                try {
                    DataType dataType = (DataType)field.get(null);
                    if (dataType == null) continue;
                    hidden.add(dataType);
                }
                catch (IllegalAccessException e) {}
            }
            dataTypes = Collections.unmodifiableSet(hidden);
        }
        return dataTypes;
    }

    public static File find(IDataType<?> type, POS pos, Collection<? extends File> files) {
        Set<String> typePatterns = type.getResourceNameHints();
        Set<String> posPatterns = pos == null ? Collections.emptySet() : pos.getResourceNameHints();
        for (File file : files) {
            String name = file.getName().toLowerCase();
            if (!DataType.containsOneOf(name, typePatterns) || !DataType.containsOneOf(name, posPatterns)) continue;
            return file;
        }
        return null;
    }

    public static boolean containsOneOf(String target, Set<String> patterns) {
        if (patterns == null || patterns.size() == 0) {
            return true;
        }
        for (String pattern : patterns) {
            if (target.indexOf(pattern) <= -1) continue;
            return true;
        }
        return false;
    }
}

