/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jwi.data;

import edu.mit.jwi.data.IContentType;
import edu.mit.jwi.data.WordnetFile;
import java.io.File;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectAccessWordnetFile<T>
extends WordnetFile<T> {
    public DirectAccessWordnetFile(File file, IContentType<T> contentType) {
        super(file, contentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLine(String key) {
        ByteBuffer buffer;
        ByteBuffer byteBuffer = buffer = this.getBuffer();
        synchronized (byteBuffer) {
            try {
                int byteOffset = Integer.parseInt(key);
                if (buffer.limit() <= byteOffset) {
                    return null;
                }
                buffer.position(byteOffset);
                String line = DirectAccessWordnetFile.getLine(buffer, this.getContentType().getCharset());
                return line.startsWith(key) ? line : null;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    }

    @Override
    public WordnetFile.LineIterator makeIterator(ByteBuffer buffer, String key) {
        return new DirectLineIterator(buffer, key);
    }

    public class DirectLineIterator
    extends WordnetFile.LineIterator {
        public DirectLineIterator(ByteBuffer buffer, String key) {
            super(DirectAccessWordnetFile.this, buffer, key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void findFirstLine(String key) {
            ByteBuffer byteBuffer = this.itrBuffer;
            synchronized (byteBuffer) {
                try {
                    Integer byteOffset = Integer.parseInt(key);
                    if (this.itrBuffer.limit() <= byteOffset) {
                        return;
                    }
                    this.itrBuffer.position(byteOffset);
                    this.next = WordnetFile.getLine(this.itrBuffer, DirectAccessWordnetFile.this.getContentType().getCharset());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }
}

