/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jwi.data;

import edu.mit.jwi.data.BinarySearchWordnetFile;
import edu.mit.jwi.data.ContentType;
import edu.mit.jwi.data.DataType;
import edu.mit.jwi.data.DirectAccessWordnetFile;
import edu.mit.jwi.data.IContentType;
import edu.mit.jwi.data.IDataProvider;
import edu.mit.jwi.data.IDataSource;
import edu.mit.jwi.data.IDataType;
import edu.mit.jwi.data.IHasLifecycle;
import edu.mit.jwi.data.ILoadPolicy;
import edu.mit.jwi.data.ILoadable;
import edu.mit.jwi.data.ILoadableDataSource;
import edu.mit.jwi.data.parse.ILineParser;
import edu.mit.jwi.item.ISynset;
import edu.mit.jwi.item.IVersion;
import edu.mit.jwi.item.POS;
import edu.mit.jwi.item.Synset;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileProvider
implements IDataProvider,
ILoadable,
ILoadPolicy {
    private final Lock lifecycleLock = new ReentrantLock();
    private final Lock loadingLock = new ReentrantLock();
    private final Map<IContentType<?>, IContentType<?>> prototypeMap;
    private URL url = null;
    private IVersion version = null;
    private Map<IContentType<?>, ILoadableDataSource<?>> fileMap = null;
    private int loadPolicy = 2;
    private transient JWIBackgroundLoader loader = null;
    private Charset charset = null;

    public FileProvider(File file) {
        this(FileProvider.toURL(file));
    }

    public FileProvider(File file, int loadPolicy) {
        this(FileProvider.toURL(file), loadPolicy, ContentType.values());
    }

    public FileProvider(File file, int loadPolicy, Collection<? extends IContentType<?>> types) {
        this(FileProvider.toURL(file), loadPolicy, types);
    }

    public FileProvider(URL url) {
        this(url, 2);
    }

    public FileProvider(URL url, int loadPolicy) {
        this(url, loadPolicy, ContentType.values());
    }

    public FileProvider(URL url, int loadPolicy, Collection<? extends IContentType<?>> types) {
        if (url == null) {
            throw new NullPointerException();
        }
        if (types.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.url = url;
        this.loadPolicy = loadPolicy;
        LinkedHashMap prototypeMap = new LinkedHashMap(types.size());
        for (IContentType<?> type : types) {
            prototypeMap.put(type, type);
        }
        this.prototypeMap = prototypeMap;
    }

    @Override
    public URL getSource() {
        return this.url;
    }

    @Override
    public int getLoadPolicy() {
        return this.loadPolicy;
    }

    @Override
    public void setSource(URL url) {
        if (this.isOpen()) {
            throw new IllegalStateException("provider currently open");
        }
        if (url == null) {
            throw new NullPointerException();
        }
        this.url = url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLoadPolicy(int policy) {
        try {
            this.loadingLock.lock();
            this.loadPolicy = policy;
        }
        finally {
            this.loadingLock.unlock();
        }
    }

    @Override
    public IVersion getVersion() {
        this.checkOpen();
        if (this.version == null) {
            this.version = this.determineVersion(this.fileMap.values());
        }
        if (this.version == IVersion.NO_VERSION) {
            return null;
        }
        return this.version;
    }

    protected IVersion determineVersion(Collection<? extends IDataSource<?>> srcs) {
        IVersion ver = IVersion.NO_VERSION;
        for (IDataSource<?> dataSrc : srcs) {
            if (dataSrc.getVersion() == null) continue;
            if (ver == IVersion.NO_VERSION) {
                ver = dataSrc.getVersion();
                continue;
            }
            if (ver.equals(dataSrc.getVersion())) continue;
            return IVersion.NO_VERSION;
        }
        return ver;
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCharset(Charset charset) {
        try {
            this.lifecycleLock.lock();
            if (this.isOpen()) {
                throw new IllegalStateException("provider currently open");
            }
            if (charset == null) {
                for (Map.Entry<IContentType<?>, IContentType<?>> e : this.prototypeMap.entrySet()) {
                    e.setValue(e.getKey());
                }
                return;
            }
            for (Map.Entry<IContentType<?>, IContentType<?>> e : this.prototypeMap.entrySet()) {
                e.setValue(new ContentType(e.getKey().getDataType(), e.getKey().getPOS(), e.getKey().getLineComparator(), charset));
            }
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    @Override
    public <T> IContentType<T> resolveContentType(IDataType<T> dt, POS pos) {
        for (Map.Entry<IContentType<?>, IContentType<?>> e : this.prototypeMap.entrySet()) {
            if (!e.getKey().getDataType().equals(dt) || e.getKey().getPOS() != pos) continue;
            return e.getValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean open() throws IOException {
        try {
            this.lifecycleLock.lock();
            this.loadingLock.lock();
            int policy = this.getLoadPolicy();
            File directory = FileProvider.toFile(this.url);
            if (!directory.exists()) {
                throw new IOException("Dictionary directory does not exist: " + directory);
            }
            ArrayList<File> files = new ArrayList<File>(Arrays.asList(directory.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.isFile();
                }
            })));
            if (files.isEmpty()) {
                throw new IOException("No files found in " + directory);
            }
            Map<IContentType<?>, ILoadableDataSource<?>> hiddenMap = this.createSourceMap(files, policy);
            if (hiddenMap.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            Map map = Collections.unmodifiableMap(Collections.emptyMap());
            if (hiddenMap.getClass() != map.getClass()) {
                hiddenMap = Collections.unmodifiableMap(hiddenMap);
            }
            this.fileMap = hiddenMap;
            try {
                switch (this.loadPolicy) {
                    case 4: {
                        this.load(false);
                        break;
                    }
                    case 8: {
                        this.load(true);
                        break;
                    }
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lifecycleLock.unlock();
            this.loadingLock.unlock();
        }
    }

    @Override
    public void load() {
        try {
            this.load(false);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(boolean block) throws InterruptedException {
        try {
            this.loadingLock.lock();
            this.checkOpen();
            if (this.isLoaded()) {
                return;
            }
            if (this.loader != null) {
                return;
            }
            this.loader = new JWIBackgroundLoader();
            this.loader.start();
            if (block) {
                this.loader.join();
            }
        }
        finally {
            this.loadingLock.lock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLoaded() {
        if (!this.isOpen()) {
            throw new IllegalStateException("provider not open");
        }
        try {
            this.loadingLock.lock();
            for (ILoadableDataSource<?> source : this.fileMap.values()) {
                if (source.isLoaded()) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.loadingLock.unlock();
        }
    }

    protected Map<IContentType<?>, ILoadableDataSource<?>> createSourceMap(List<File> files, int policy) throws IOException {
        HashMap result = new HashMap();
        for (IContentType<?> type : this.prototypeMap.values()) {
            File file = DataType.find(type.getDataType(), type.getPOS(), files);
            if (file == null) continue;
            files.remove(file);
            result.put(type, this.createDataSource(file, type, policy));
        }
        return result;
    }

    protected <T> ILoadableDataSource<T> createDataSource(File file, IContentType<T> type, int policy) throws IOException {
        ILoadableDataSource<T> src;
        if (type.getDataType() == DataType.DATA) {
            Iterator itr;
            String firstLine;
            src = this.createDirectAccess(file, type);
            src.open();
            if (policy == 8) {
                try {
                    src.load(true);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if ((firstLine = (String)(itr = src.iterator()).next()) == null) {
                return src;
            }
            ILineParser<T> parser = type.getDataType().getParser();
            ISynset s = (ISynset)parser.parseLine(firstLine);
            String key = Synset.zeroFillOffset(s.getOffset());
            String soughtLine = src.getLine(key);
            if (soughtLine != null) {
                return src;
            }
            System.err.println(System.currentTimeMillis() + " - Error on direct access in " + type.getPOS().toString() + " data file: check CR/LF endings");
        }
        src = this.createBinarySearch(file, type);
        src.open();
        if (policy == 8) {
            try {
                src.load(true);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return src;
    }

    protected <T> ILoadableDataSource<T> createDirectAccess(File file, IContentType<T> type) throws IOException {
        return new DirectAccessWordnetFile<T>(file, type);
    }

    protected <T> ILoadableDataSource<T> createBinarySearch(File file, IContentType<T> type) throws IOException {
        return new BinarySearchWordnetFile<T>(file, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOpen() {
        try {
            this.lifecycleLock.lock();
            boolean bl = this.fileMap != null;
            return bl;
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this.lifecycleLock.lock();
            if (!this.isOpen()) {
                return;
            }
            if (this.loader != null) {
                this.loader.cancel();
            }
            for (ILoadableDataSource<?> source : this.fileMap.values()) {
                source.close();
            }
            this.fileMap = null;
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    protected void checkOpen() {
        if (!this.isOpen()) {
            throw new IHasLifecycle.ObjectClosedException();
        }
    }

    public <T> ILoadableDataSource<T> getSource(IContentType<T> type) {
        this.checkOpen();
        IContentType<Object> actualType = this.prototypeMap.get(type);
        if (actualType == null) {
            actualType = type;
        }
        return this.fileMap.get(actualType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<? extends IContentType<?>> getTypes() {
        try {
            this.lifecycleLock.lock();
            LinkedHashSet linkedHashSet = new LinkedHashSet(this.prototypeMap.values());
            return linkedHashSet;
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    public static File toFile(URL url) {
        if (!url.getProtocol().equals("file")) {
            throw new IllegalArgumentException("URL source must use 'file' protocol");
        }
        try {
            return new File(URLDecoder.decode(url.getPath(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static URL toURL(File file) {
        if (file == null) {
            throw new NullPointerException();
        }
        try {
            URI uri = new URI("file", "//", file.toURL().getPath(), null);
            return new URL("file", null, uri.getRawPath());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isLocalDirectory(URL url) {
        if (!url.getProtocol().equals("file")) {
            return false;
        }
        File file = FileProvider.toFile(url);
        if (file == null) {
            return false;
        }
        return FileProvider.isLocalDirectory(file);
    }

    public static boolean isLocalDirectory(File dir) {
        return dir.exists() && dir.isDirectory();
    }

    protected class JWIBackgroundLoader
    extends Thread {
        private transient boolean cancel = false;

        public JWIBackgroundLoader() {
            this.setName(JWIBackgroundLoader.class.getSimpleName());
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                for (ILoadableDataSource source : FileProvider.this.fileMap.values()) {
                    if (this.cancel || source.isLoaded()) continue;
                    try {
                        source.load(true);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                FileProvider.this.loader = null;
            }
        }

        public void cancel() {
            this.cancel = true;
            try {
                this.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

