/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jwi.data.parse;

import edu.mit.jwi.data.parse.ILineParser;
import edu.mit.jwi.item.AdjMarker;
import edu.mit.jwi.item.ILexFile;
import edu.mit.jwi.item.IPointer;
import edu.mit.jwi.item.ISynset;
import edu.mit.jwi.item.ISynsetID;
import edu.mit.jwi.item.IVerbFrame;
import edu.mit.jwi.item.LexFile;
import edu.mit.jwi.item.POS;
import edu.mit.jwi.item.Pointer;
import edu.mit.jwi.item.Synset;
import edu.mit.jwi.item.SynsetID;
import edu.mit.jwi.item.UnknownLexFile;
import edu.mit.jwi.item.VerbFrame;
import edu.mit.jwi.item.WordID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataLineParser
implements ILineParser<ISynset> {
    private static DataLineParser instance;

    public static DataLineParser getInstance() {
        if (instance == null) {
            instance = new DataLineParser();
        }
        return instance;
    }

    protected DataLineParser() {
    }

    @Override
    public ISynset parseLine(String line) {
        if (line == null) {
            throw new NullPointerException();
        }
        try {
            StringTokenizer tokenizer = new StringTokenizer(line, " ");
            int offset = Integer.parseInt(tokenizer.nextToken());
            int lex_filenum = Integer.parseInt(tokenizer.nextToken());
            ILexFile lexFile = this.resolveLexicalFile(lex_filenum);
            char synset_tag = tokenizer.nextToken().charAt(0);
            POS synset_pos = POS.getPartOfSpeech(synset_tag);
            SynsetID synsetID = new SynsetID(offset, synset_pos);
            boolean isAdjSat = synset_tag == 's';
            boolean isAdjHead = !isAdjSat && lex_filenum == 0;
            int wordCount = Integer.parseInt(tokenizer.nextToken(), 16);
            Synset.IWordBuilder[] wordProxies = new Synset.IWordBuilder[wordCount];
            for (int i = 0; i < wordCount; ++i) {
                String lemma = tokenizer.nextToken();
                AdjMarker marker = null;
                if (synset_pos == POS.ADJECTIVE) {
                    for (AdjMarker adjMarker : AdjMarker.values()) {
                        if (!lemma.endsWith(adjMarker.getSymbol())) continue;
                        marker = adjMarker;
                        lemma = lemma.substring(0, lemma.length() - adjMarker.getSymbol().length());
                    }
                }
                int lexID = Integer.parseInt(tokenizer.nextToken(), 16);
                wordProxies[i] = new Synset.WordBuilder(i + 1, lemma, lexID, marker);
            }
            int pointerCount = Integer.parseInt(tokenizer.nextToken());
            HashMap<IPointer, ArrayList<SynsetID>> synsetPointerMap = null;
            for (int i = 0; i < pointerCount; ++i) {
                IPointer pointer_type = this.resolvePointer(tokenizer.nextToken(), synset_pos);
                int target_offset = Integer.parseInt(tokenizer.nextToken());
                POS target_pos = POS.getPartOfSpeech(tokenizer.nextToken().charAt(0));
                SynsetID target_synset_id = new SynsetID(target_offset, target_pos);
                int source_target_num = Integer.parseInt(tokenizer.nextToken(), 16);
                if (source_target_num == 0) {
                    ArrayList<SynsetID> pointerList;
                    if (synsetPointerMap == null) {
                        synsetPointerMap = new HashMap<IPointer, ArrayList<SynsetID>>();
                    }
                    if ((pointerList = (ArrayList<SynsetID>)synsetPointerMap.get(pointer_type)) == null) {
                        pointerList = new ArrayList<SynsetID>();
                        synsetPointerMap.put(pointer_type, pointerList);
                    }
                    pointerList.add(target_synset_id);
                    continue;
                }
                int source_num = source_target_num / 256;
                int target_num = source_target_num & 0xFF;
                WordID target_word_id = new WordID((ISynsetID)target_synset_id, target_num);
                wordProxies[source_num - 1].addRelatedWord(pointer_type, target_word_id);
            }
            if (synsetPointerMap != null) {
                for (ArrayList list : synsetPointerMap.values()) {
                    list.trimToSize();
                }
            }
            if (synset_pos == POS.VERB) {
                int verbFrameCount = Integer.parseInt(tokenizer.nextToken());
                for (int i = 0; i < verbFrameCount; ++i) {
                    tokenizer.nextToken();
                    int frame_num = Integer.parseInt(tokenizer.nextToken());
                    IVerbFrame frame = this.resolveVerbFrame(frame_num);
                    int word_num = Integer.parseInt(tokenizer.nextToken(), 16);
                    if (word_num > 0) {
                        wordProxies[word_num - 1].addVerbFrame(frame);
                        continue;
                    }
                    for (Synset.IWordBuilder proxy : wordProxies) {
                        proxy.addVerbFrame(frame);
                    }
                }
            }
            String gloss = "";
            int index = line.indexOf(124);
            if (index > 0) {
                gloss = line.substring(index + 2).trim();
            }
            List<Synset.IWordBuilder> words = Arrays.asList(wordProxies);
            return new Synset(synsetID, lexFile, isAdjSat, isAdjHead, gloss, words, (Map<IPointer, ? extends List<ISynsetID>>)synsetPointerMap);
        }
        catch (NumberFormatException e) {
            throw new ILineParser.MisformattedLineException(line, e);
        }
        catch (NoSuchElementException e) {
            throw new ILineParser.MisformattedLineException(line, e);
        }
    }

    protected IVerbFrame resolveVerbFrame(int frameNum) {
        return VerbFrame.getFrame(frameNum);
    }

    protected ILexFile resolveLexicalFile(int lexFileNum) {
        LexFile lexFile = LexFile.getLexicalFile(lexFileNum);
        if (lexFile == null) {
            lexFile = UnknownLexFile.getUnknownLexicalFile(lexFileNum);
        }
        return lexFile;
    }

    protected IPointer resolvePointer(String symbol, POS pos) {
        return Pointer.getPointerType(symbol, pos);
    }
}

