/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jwi.item;

import edu.mit.jwi.item.IExceptionEntryID;
import edu.mit.jwi.item.POS;

public class ExceptionEntryID
implements IExceptionEntryID {
    private static final long serialVersionUID = -8891377527593261453L;
    private final String surfaceForm;
    private final POS pos;

    public ExceptionEntryID(String surfaceForm, POS pos) {
        if (pos == null) {
            throw new NullPointerException();
        }
        if (surfaceForm == null) {
            throw new NullPointerException();
        }
        if ((surfaceForm = surfaceForm.trim()).length() == 0) {
            throw new IllegalArgumentException();
        }
        this.surfaceForm = surfaceForm.toLowerCase();
        this.pos = pos;
    }

    public String getSurfaceForm() {
        return this.surfaceForm;
    }

    public POS getPOS() {
        return this.pos;
    }

    public String toString() {
        return "EID-" + this.surfaceForm + "-" + this.pos.getTag();
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.surfaceForm.hashCode();
        result = 31 * result + this.pos.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IExceptionEntryID)) {
            return false;
        }
        IExceptionEntryID other = (IExceptionEntryID)obj;
        if (!this.surfaceForm.equals(other.getSurfaceForm())) {
            return false;
        }
        return this.pos.equals((Object)other.getPOS());
    }

    public static ExceptionEntryID parseExceptionEntryID(String value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (!value.startsWith("EID-")) {
            throw new IllegalArgumentException();
        }
        if (value.charAt(value.length() - 2) != '-') {
            throw new IllegalArgumentException();
        }
        POS pos = POS.getPartOfSpeech(value.charAt(value.length() - 1));
        return new ExceptionEntryID(value.substring(4, value.length() - 2), pos);
    }
}

