/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jwi.item;

import edu.mit.jwi.item.IExceptionEntryProxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionEntryProxy
implements IExceptionEntryProxy {
    private static final long serialVersionUID = 240L;
    private final String surfaceForm;
    private final List<String> rootForms;

    public ExceptionEntryProxy(IExceptionEntryProxy proxy) {
        if (proxy == null) {
            throw new NullPointerException();
        }
        this.surfaceForm = proxy.getSurfaceForm();
        this.rootForms = proxy.getRootForms();
    }

    public ExceptionEntryProxy(String surfaceForm, String ... rootForms) {
        if (surfaceForm == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < rootForms.length; ++i) {
            if (rootForms[i] == null) {
                throw new NullPointerException();
            }
            rootForms[i] = rootForms[i].trim();
            if (rootForms[i].length() != 0) continue;
            throw new IllegalArgumentException();
        }
        this.surfaceForm = surfaceForm;
        this.rootForms = Collections.unmodifiableList(Arrays.asList(rootForms));
    }

    @Override
    public String getSurfaceForm() {
        return this.surfaceForm;
    }

    @Override
    public List<String> getRootForms() {
        return this.rootForms;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("EXC-");
        sb.append(this.surfaceForm);
        sb.append('[');
        Iterator<String> i = this.rootForms.iterator();
        while (i.hasNext()) {
            sb.append(i.next());
            if (!i.hasNext()) continue;
            sb.append(',');
        }
        sb.append(']');
        return sb.toString();
    }
}

