/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jwi.item;

import edu.mit.jwi.item.IIndexWord;
import edu.mit.jwi.item.IIndexWordID;
import edu.mit.jwi.item.IPointer;
import edu.mit.jwi.item.IWordID;
import edu.mit.jwi.item.IndexWordID;
import edu.mit.jwi.item.POS;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexWord
implements IIndexWord {
    private static final long serialVersionUID = 240L;
    private final IIndexWordID id;
    private final int tagSenseCount;
    private final Set<IPointer> pointers;
    private final List<IWordID> wordIDs;

    public IndexWord(String lemma, POS pos, int tagSenseCnt, IWordID ... words) {
        this((IIndexWordID)new IndexWordID(lemma, pos), tagSenseCnt, (IPointer[])null, words);
    }

    public IndexWord(String lemma, POS pos, int tagSenseCnt, IPointer[] ptrs, IWordID ... words) {
        this((IIndexWordID)new IndexWordID(lemma, pos), tagSenseCnt, ptrs, words);
    }

    public IndexWord(IIndexWordID id, int tagSenseCnt, IWordID ... words) {
        this(id, tagSenseCnt, (IPointer[])null, words);
    }

    public IndexWord(IIndexWordID id, int tagSenseCnt, IPointer[] ptrs, IWordID ... words) {
        Set pointers;
        if (id == null) {
            throw new NullPointerException();
        }
        if (tagSenseCnt < 0) {
            throw new IllegalArgumentException();
        }
        if (words.length == 0) {
            throw new IllegalArgumentException();
        }
        for (IWordID wid : words) {
            if (wid != null) continue;
            throw new NullPointerException();
        }
        if (ptrs == null || ptrs.length == 0) {
            pointers = Collections.emptySet();
        } else {
            pointers = new HashSet(ptrs.length);
            for (IPointer p : ptrs) {
                if (p == null) {
                    throw new NullPointerException();
                }
                pointers.add(p);
            }
        }
        this.id = id;
        this.tagSenseCount = tagSenseCnt;
        this.wordIDs = Collections.unmodifiableList(Arrays.asList(words));
        this.pointers = pointers;
    }

    @Override
    public String getLemma() {
        return this.id.getLemma();
    }

    @Override
    public Set<IPointer> getPointers() {
        return this.pointers;
    }

    @Override
    public List<IWordID> getWordIDs() {
        return this.wordIDs;
    }

    @Override
    public int getTagSenseCount() {
        return this.tagSenseCount;
    }

    @Override
    public IIndexWordID getID() {
        return this.id;
    }

    @Override
    public POS getPOS() {
        return this.id.getPOS();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append(this.id.getLemma());
        sb.append(" (");
        sb.append((Object)this.id.getPOS());
        sb.append(") ");
        Iterator<IWordID> i = this.wordIDs.iterator();
        while (i.hasNext()) {
            sb.append(i.next().toString());
            if (!i.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(']');
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id.hashCode();
        result = 31 * result + this.tagSenseCount;
        result = 31 * result + ((Object)this.wordIDs).hashCode();
        result = 31 * result + ((Object)this.pointers).hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IIndexWord)) {
            return false;
        }
        IndexWord other = (IndexWord)obj;
        if (!this.id.equals(other.getID())) {
            return false;
        }
        if (this.tagSenseCount != other.getTagSenseCount()) {
            return false;
        }
        if (!((Object)this.wordIDs).equals(other.getWordIDs())) {
            return false;
        }
        return ((Object)this.pointers).equals(other.getPointers());
    }
}

