/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jwi.item;

import edu.mit.jwi.item.IIndexWordID;
import edu.mit.jwi.item.POS;
import java.util.regex.Pattern;

public class IndexWordID
implements IIndexWordID {
    private static final long serialVersionUID = 4683552775420575309L;
    protected static final Pattern whitespace = Pattern.compile("\\s+");
    private final String lemma;
    private final POS pos;

    public IndexWordID(String lemma, POS pos) {
        if (pos == null) {
            throw new NullPointerException();
        }
        if ((lemma = lemma.toLowerCase().trim()).length() == 0) {
            throw new IllegalArgumentException();
        }
        this.lemma = whitespace.matcher(lemma).replaceAll("_");
        this.pos = pos;
    }

    public String getLemma() {
        return this.lemma;
    }

    public POS getPOS() {
        return this.pos;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.lemma.hashCode();
        result = 31 * result + this.pos.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IIndexWordID)) {
            return false;
        }
        IIndexWordID other = (IIndexWordID)obj;
        if (!this.lemma.equals(other.getLemma())) {
            return false;
        }
        return this.pos.equals((Object)other.getPOS());
    }

    public String toString() {
        return "XID-" + this.lemma + "-" + this.pos.getTag();
    }

    public static IndexWordID parseIndexWordID(String value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (!value.startsWith("XID-")) {
            throw new IllegalArgumentException();
        }
        if (value.charAt(value.length() - 2) != '-') {
            throw new IllegalArgumentException();
        }
        POS pos = POS.getPartOfSpeech(value.charAt(value.length() - 1));
        return new IndexWordID(value.substring(4, value.length() - 2), pos);
    }
}

