/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jwi.item;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum POS {
    NOUN("noun", 'n', 1, "noun"),
    VERB("verb", 'v', 2, "verb"),
    ADJECTIVE("adjective", 'a', 3, "adj", "adjective"),
    ADVERB("adverb", 'r', 4, "adv", "adverb");

    public static final int NUM_NOUN = 1;
    public static final int NUM_VERB = 2;
    public static final int NUM_ADJECTIVE = 3;
    public static final int NUM_ADVERB = 4;
    public static final int NUM_ADJECTIVE_SATELLITE = 5;
    public static final char TAG_NOUN = 'n';
    public static final char TAG_VERB = 'v';
    public static final char TAG_ADJECTIVE = 'a';
    public static final char TAG_ADVERB = 'r';
    public static final char TAG_ADJECTIVE_SATELLITE = 's';
    private final String name;
    private final char tag;
    private final int num;
    private final Set<String> filenameHints;

    private POS(String name, char tag, int type, String ... patterns) {
        this.name = name;
        this.tag = tag;
        this.num = type;
        this.filenameHints = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(patterns)));
    }

    public Set<String> getResourceNameHints() {
        return this.filenameHints;
    }

    public char getTag() {
        return this.tag;
    }

    public int getNumber() {
        return this.num;
    }

    public String toString() {
        return this.name;
    }

    public static boolean isAdjectiveSatellite(int num) {
        return num == 5;
    }

    public static boolean isAdjectiveSatellite(char tag) {
        return tag == 's' || tag == 'S';
    }

    public static POS getPartOfSpeech(int num) {
        switch (num) {
            case 1: {
                return NOUN;
            }
            case 2: {
                return VERB;
            }
            case 4: {
                return ADVERB;
            }
            case 3: 
            case 5: {
                return ADJECTIVE;
            }
        }
        return null;
    }

    public static POS getPartOfSpeech(char tag) {
        switch (tag) {
            case 'N': 
            case 'n': {
                return NOUN;
            }
            case 'V': 
            case 'v': {
                return VERB;
            }
            case 'R': 
            case 'r': {
                return ADVERB;
            }
            case 'A': 
            case 'S': 
            case 'a': 
            case 's': {
                return ADJECTIVE;
            }
        }
        return null;
    }
}

