/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jwi.item;

import edu.mit.jwi.item.ISenseEntry;
import edu.mit.jwi.item.ISenseKey;
import edu.mit.jwi.item.POS;
import edu.mit.jwi.item.Synset;

public class SenseEntry
implements ISenseEntry {
    private static final long serialVersionUID = 240L;
    private final int offset;
    private final int num;
    private final int count;
    private final ISenseKey key;

    public SenseEntry(ISenseKey key, int offset, int num, int count) {
        if (key == null) {
            throw new NullPointerException();
        }
        Synset.checkOffset(offset);
        this.key = key;
        this.offset = offset;
        this.num = num;
        this.count = count;
    }

    public int getOffset() {
        return this.offset;
    }

    public POS getPOS() {
        return this.key.getPOS();
    }

    public int getSenseNumber() {
        return this.num;
    }

    public ISenseKey getSenseKey() {
        return this.key;
    }

    public int getTagCount() {
        return this.count;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.count;
        result = 31 * result + this.key.hashCode();
        result = 31 * result + this.num;
        result = 31 * result + this.offset;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ISenseEntry)) {
            return false;
        }
        ISenseEntry other = (ISenseEntry)obj;
        if (this.count != other.getTagCount()) {
            return false;
        }
        if (this.num != other.getSenseNumber()) {
            return false;
        }
        if (this.offset != other.getOffset()) {
            return false;
        }
        return this.key.equals(other.getSenseKey());
    }
}

