/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jwi.item;

import edu.mit.jwi.item.AdjMarker;
import edu.mit.jwi.item.IPointer;
import edu.mit.jwi.item.ISenseKey;
import edu.mit.jwi.item.ISynset;
import edu.mit.jwi.item.ISynsetID;
import edu.mit.jwi.item.IVerbFrame;
import edu.mit.jwi.item.IWord;
import edu.mit.jwi.item.IWordID;
import edu.mit.jwi.item.POS;
import edu.mit.jwi.item.SenseKey;
import edu.mit.jwi.item.WordID;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Word
implements IWord {
    private static final long serialVersionUID = 240L;
    private final IWordID id;
    private final ISynset synset;
    private final ISenseKey senseKey;
    private final AdjMarker adjMarker;
    private final int lexID;
    private final List<IVerbFrame> frames;
    private final List<IWordID> allWords;
    private final Map<IPointer, List<IWordID>> wordMap;
    private static final String[] lexIDNumStrs = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09"};

    public Word(ISynset synset, int number, String lemma, int lexID, AdjMarker adjMarker, List<IVerbFrame> frames, Map<IPointer, ? extends List<IWordID>> pointers) {
        this(synset, new WordID((ISynsetID)synset.getID(), number, lemma), lexID, adjMarker, frames, pointers);
    }

    public Word(ISynset synset, IWordID id, int lexID, AdjMarker adjMarker, List<IVerbFrame> frames, Map<IPointer, ? extends List<IWordID>> pointers) {
        if (synset == null) {
            throw new NullPointerException();
        }
        if (id == null) {
            throw new NullPointerException();
        }
        Word.checkLexicalID(lexID);
        if (synset.getPOS() != POS.ADJECTIVE && adjMarker != null) {
            throw new IllegalArgumentException();
        }
        LinkedHashSet hiddenSet = null;
        HashMap hiddenMap = null;
        if (pointers != null) {
            hiddenSet = new LinkedHashSet();
            hiddenMap = new HashMap(pointers.size());
            for (Map.Entry<IPointer, ? extends List<IWordID>> entry : pointers.entrySet()) {
                if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
                hiddenMap.put(entry.getKey(), Collections.unmodifiableList(new ArrayList(entry.getValue())));
                hiddenSet.addAll(entry.getValue());
            }
        }
        this.synset = synset;
        this.id = id;
        this.lexID = lexID;
        this.adjMarker = adjMarker;
        this.senseKey = new SenseKey(id.getLemma(), lexID, synset);
        this.allWords = hiddenSet != null && !hiddenSet.isEmpty() ? Collections.unmodifiableList(new ArrayList(hiddenSet)) : Collections.emptyList();
        this.wordMap = hiddenMap != null && !hiddenMap.isEmpty() ? Collections.unmodifiableMap(hiddenMap) : Collections.emptyMap();
        this.frames = frames == null || frames.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<IVerbFrame>(frames));
    }

    @Override
    public IWordID getID() {
        return this.id;
    }

    @Override
    public String getLemma() {
        return this.id.getLemma();
    }

    @Override
    public POS getPOS() {
        return this.id.getSynsetID().getPOS();
    }

    @Override
    public ISynset getSynset() {
        return this.synset;
    }

    @Override
    public int getLexicalID() {
        return this.lexID;
    }

    @Override
    public AdjMarker getAdjectiveMarker() {
        return this.adjMarker;
    }

    @Override
    public ISenseKey getSenseKey() {
        return this.senseKey;
    }

    @Override
    public Map<IPointer, List<IWordID>> getRelatedMap() {
        return this.wordMap;
    }

    @Override
    public List<IWordID> getRelatedWords(IPointer type) {
        List<IWordID> result = this.wordMap.get(type);
        return result == null ? Collections.emptyList() : result;
    }

    @Override
    public List<IWordID> getRelatedWords() {
        return this.wordMap == null ? Collections.emptyList() : this.allWords;
    }

    @Override
    public List<IVerbFrame> getVerbFrames() {
        return this.frames;
    }

    public String toString() {
        if (this.id.getWordNumber() == 0) {
            return "W-" + this.id.getSynsetID().toString().substring(4) + "-?-" + this.id.getLemma();
        }
        return "W-" + this.id.getSynsetID().toString().substring(4) + "-" + this.id.getWordNumber() + "-" + this.id.getLemma();
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 31 + ((Object)this.frames).hashCode();
        result = 31 * result + ((Object)this.wordMap).hashCode();
        result = 31 * result + this.id.hashCode();
        result = 31 * result + this.lexID;
        result = 31 * result + (this.adjMarker == null ? 0 : this.adjMarker.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Word)) {
            return false;
        }
        Word that = (Word)obj;
        if (!this.id.equals(that.id)) {
            return false;
        }
        if (this.lexID != that.lexID) {
            return false;
        }
        if (this.adjMarker == null ? that.adjMarker != null : !this.adjMarker.equals((Object)that.adjMarker)) {
            return false;
        }
        if (!((Object)this.frames).equals(that.frames)) {
            return false;
        }
        return ((Object)this.wordMap).equals(that.wordMap);
    }

    public static void checkWordNumber(int num) {
        if (Word.isIllegalWordNumber(num)) {
            throw new IllegalArgumentException("'" + num + " is an illegal word number: word numbers are in the closed range [1,255]");
        }
    }

    public static void checkLexicalID(int id) {
        if (Word.isIllegalLexicalID(id)) {
            throw new IllegalArgumentException("'" + id + " is an illegal lexical id: lexical ids are in the closed range [0,15]");
        }
    }

    public static boolean isIllegalLexicalID(int id) {
        if (id < 0) {
            return true;
        }
        return id > 15;
    }

    public static boolean isIllegalWordNumber(int num) {
        if (num < 1) {
            return true;
        }
        return num > 255;
    }

    public static String getLexicalIDForDataFile(int lexID) {
        Word.checkLexicalID(lexID);
        return Integer.toHexString(lexID);
    }

    public static String getLexicalIDForSenseKey(int lexID) {
        Word.checkLexicalID(lexID);
        return lexID < 10 ? lexIDNumStrs[lexID] : Integer.toString(lexID);
    }

    public static String zeroFillWordNumber(int num) {
        int i;
        Word.checkWordNumber(num);
        StringBuilder sb = new StringBuilder(2);
        String str = Integer.toHexString(num);
        int numZeros = 2 - str.length();
        for (i = 0; i < numZeros; ++i) {
            sb.append('0');
        }
        for (i = 0; i < str.length(); ++i) {
            sb.append(Character.toUpperCase(str.charAt(i)));
        }
        return sb.toString();
    }
}

