/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jwi.item;

import edu.mit.jwi.item.ISynsetID;
import edu.mit.jwi.item.IWordID;
import edu.mit.jwi.item.POS;
import edu.mit.jwi.item.Synset;
import edu.mit.jwi.item.SynsetID;
import edu.mit.jwi.item.Word;

public class WordID
implements IWordID {
    private static final long serialVersionUID = 3163309710173885763L;
    public static final String wordIDPrefix = "WID-";
    public static final String unknownLemma = "?";
    public static final String unknownWordNumber = "??";
    private final ISynsetID id;
    private final String lemma;
    private final int num;

    public WordID(int offset, POS pos, int num) {
        this((ISynsetID)new SynsetID(offset, pos), num);
    }

    public WordID(int offset, POS pos, String lemma) {
        this((ISynsetID)new SynsetID(offset, pos), lemma);
    }

    public WordID(ISynsetID id, int num) {
        if (id == null) {
            throw new NullPointerException();
        }
        Word.checkWordNumber(num);
        this.id = id;
        this.num = num;
        this.lemma = null;
    }

    public WordID(ISynsetID id, String lemma) {
        if (id == null) {
            throw new NullPointerException();
        }
        if (lemma.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        this.id = id;
        this.num = -1;
        this.lemma = lemma.toLowerCase();
    }

    public WordID(ISynsetID id, int num, String lemma) {
        if (id == null) {
            throw new NullPointerException();
        }
        if (lemma.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        Word.checkWordNumber(num);
        this.id = id;
        this.num = num;
        this.lemma = lemma;
    }

    public ISynsetID getSynsetID() {
        return this.id;
    }

    public int getWordNumber() {
        return this.num;
    }

    public String getLemma() {
        return this.lemma;
    }

    public POS getPOS() {
        return this.id.getPOS();
    }

    public int hashCode() {
        return 31 * this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WordID other = (WordID)obj;
        if (!this.id.equals(other.id)) {
            return false;
        }
        if (other.num != -1 && this.num != -1 && other.num != this.num) {
            return false;
        }
        return other.lemma == null || this.lemma == null || other.lemma.equalsIgnoreCase(this.lemma);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(wordIDPrefix);
        sb.append(Synset.zeroFillOffset(this.id.getOffset()));
        sb.append('-');
        sb.append(Character.toUpperCase(this.id.getPOS().getTag()));
        sb.append('-');
        sb.append(this.num < 0 ? unknownWordNumber : Word.zeroFillWordNumber(this.num));
        sb.append('-');
        sb.append(this.lemma == null ? unknownLemma : this.lemma);
        return sb.toString();
    }

    public static IWordID parseWordID(String value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value.length() < 19) {
            throw new IllegalArgumentException();
        }
        if (!value.startsWith(wordIDPrefix)) {
            throw new IllegalArgumentException();
        }
        int offset = Integer.parseInt(value.substring(4, 12));
        POS pos = POS.getPartOfSpeech(value.charAt(13));
        SynsetID id = new SynsetID(offset, pos);
        String numStr = value.substring(15, 17);
        if (!numStr.equals(unknownWordNumber)) {
            int num = Integer.parseInt(numStr, 16);
            return new WordID((ISynsetID)id, num);
        }
        String lemma = value.substring(18);
        if (lemma.equals(unknownLemma) || lemma.length() == 0) {
            throw new IllegalArgumentException();
        }
        return new WordID((ISynsetID)id, lemma);
    }
}

