/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jwi.morph;

import edu.mit.jwi.item.POS;
import edu.mit.jwi.morph.IStemmer;
import edu.mit.jwi.morph.StemmingRule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleStemmer
implements IStemmer {
    public static final String underscore = "_";
    Pattern whitespace = Pattern.compile("\\s+");
    public static final String SUFFIX_ches = "ches";
    public static final String SUFFIX_ed = "ed";
    public static final String SUFFIX_es = "es";
    public static final String SUFFIX_est = "est";
    public static final String SUFFIX_er = "er";
    public static final String SUFFIX_ful = "ful";
    public static final String SUFFIX_ies = "ies";
    public static final String SUFFIX_ing = "ing";
    public static final String SUFFIX_men = "men";
    public static final String SUFFIX_s = "s";
    public static final String SUFFIX_ss = "ss";
    public static final String SUFFIX_ses = "ses";
    public static final String SUFFIX_shes = "shes";
    public static final String SUFFIX_xes = "xes";
    public static final String SUFFIX_zes = "zes";
    public static final String ENDING_null = "";
    public static final String ENDING_ch = "ch";
    public static final String ENDING_e = "e";
    public static final String ENDING_man = "man";
    public static final String ENDING_s = "s";
    public static final String ENDING_sh = "sh";
    public static final String ENDING_x = "x";
    public static final String ENDING_y = "y";
    public static final String ENDING_z = "z";
    public static final Map<POS, List<StemmingRule>> ruleMap;

    public Map<POS, List<StemmingRule>> getRuleMap() {
        return ruleMap;
    }

    @Override
    public List<String> findStems(String word, POS pos) {
        word = this.normalize(word);
        if (pos == null) {
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            for (POS p : POS.values()) {
                result.addAll(this.findStems(word, p));
            }
            if (result.isEmpty()) {
                return Collections.emptyList();
            }
            return new ArrayList<String>(result);
        }
        boolean isCollocation = word.contains(underscore);
        switch (pos) {
            case NOUN: {
                return isCollocation ? this.getNounCollocationRoots(word) : this.stripNounSuffix(word);
            }
            case VERB: {
                return isCollocation ? this.getVerbCollocationRoots(word) : this.stripVerbSuffix(word);
            }
            case ADJECTIVE: {
                return this.stripAdjectiveSuffix(word);
            }
            case ADVERB: {
                return Collections.emptyList();
            }
        }
        throw new IllegalArgumentException("This should not happen");
    }

    protected String normalize(String word) {
        word = word.toLowerCase();
        word = word.replace('_', ' ');
        if ((word = word.trim()).length() == 0) {
            throw new IllegalArgumentException();
        }
        word = this.whitespace.matcher(word).replaceAll(underscore);
        return word;
    }

    protected List<String> stripNounSuffix(String noun) {
        if (noun.length() <= 2) {
            return Collections.emptyList();
        }
        String word = noun;
        String suffix = null;
        if (noun.endsWith(SUFFIX_ful)) {
            word = noun.substring(0, noun.length() - SUFFIX_ful.length());
            suffix = SUFFIX_ful;
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (StemmingRule rule : this.getRuleMap().get((Object)POS.NOUN)) {
            String root = rule.apply(word, suffix);
            if (root == null || root.length() <= 0) continue;
            result.add(root);
        }
        return result.isEmpty() ? Collections.emptyList() : new ArrayList(result);
    }

    protected List<String> getNounCollocationRoots(String composite) {
        String[] parts = composite.split(underscore);
        if (parts.length < 2) {
            return Collections.emptyList();
        }
        ArrayList<List<String>> rootSets = new ArrayList<List<String>>(parts.length);
        for (int i = 0; i < parts.length; ++i) {
            rootSets.add(this.findStems(parts[i], POS.NOUN));
        }
        HashSet<StringBuffer> poss = new HashSet<StringBuffer>();
        List rootSet = (List)rootSets.get(0);
        if (rootSet == null) {
            poss.add(new StringBuffer(parts[0]));
        } else {
            for (String root : rootSet) {
                poss.add(new StringBuffer(root));
            }
        }
        for (int i = 1; i < rootSets.size(); ++i) {
            rootSet = (List)rootSets.get(i);
            if (rootSet.isEmpty()) {
                for (StringBuffer p : poss) {
                    p.append(underscore);
                    p.append(parts[i]);
                }
                continue;
            }
            HashSet<StringBuffer> replace = new HashSet<StringBuffer>();
            for (StringBuffer p : poss) {
                for (String root : rootSet) {
                    StringBuffer newBuf = new StringBuffer();
                    newBuf.append(p.toString());
                    newBuf.append(underscore);
                    newBuf.append((Object)root);
                    replace.add(newBuf);
                }
            }
            poss.clear();
            poss.addAll(replace);
        }
        if (poss.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (StringBuffer p : poss) {
            String root = p.toString().trim();
            if (root.length() == 0) continue;
            result.add(root);
        }
        return new ArrayList<String>(result);
    }

    protected List<String> stripVerbSuffix(String verb) {
        if (verb.length() <= 2) {
            return Collections.emptyList();
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (StemmingRule rule : this.getRuleMap().get((Object)POS.VERB)) {
            String root = rule.apply(verb);
            if (root == null || root.length() <= 0) continue;
            result.add(root);
        }
        return result.isEmpty() ? Collections.emptyList() : new ArrayList(result);
    }

    protected List<String> getVerbCollocationRoots(String composite) {
        String[] parts = composite.split(underscore);
        if (parts.length < 2) {
            return Collections.emptyList();
        }
        ArrayList<List<String>> rootSets = new ArrayList<List<String>>(parts.length);
        for (int i = 0; i < parts.length; ++i) {
            rootSets.add(this.findStems(parts[i], POS.VERB));
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        StringBuffer rootBuffer = new StringBuffer();
        for (int i = 0; i < parts.length; ++i) {
            if (rootSets.get(i) == null) continue;
            for (String partRoot : (List)rootSets.get(i)) {
                rootBuffer.replace(0, rootBuffer.length(), ENDING_null);
                for (int j = 0; j < parts.length; ++j) {
                    if (j == i) {
                        rootBuffer.append(partRoot);
                    } else {
                        rootBuffer.append(parts[j]);
                    }
                    if (j >= parts.length - 1) continue;
                    rootBuffer.append(underscore);
                }
                result.add(rootBuffer.toString());
            }
        }
        Iterator i = result.iterator();
        while (i.hasNext()) {
            if (((String)i.next()).length() != 0) continue;
            i.remove();
        }
        return result.isEmpty() ? Collections.emptyList() : new ArrayList(result);
    }

    protected List<String> stripAdjectiveSuffix(String adj) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (StemmingRule rule : this.getRuleMap().get((Object)POS.ADJECTIVE)) {
            String root = rule.apply(adj);
            if (root == null || root.length() <= 0) continue;
            result.add(root);
        }
        return result.isEmpty() ? Collections.emptyList() : new ArrayList(result);
    }

    static {
        TreeMap ruleMapHidden = new TreeMap();
        String[] nullSuffixArray = null;
        ArrayList<StemmingRule> list = new ArrayList<StemmingRule>(8);
        list.add(new StemmingRule("s", ENDING_null, POS.NOUN, SUFFIX_ss));
        list.add(new StemmingRule(SUFFIX_ses, "s", POS.NOUN, nullSuffixArray));
        list.add(new StemmingRule(SUFFIX_xes, ENDING_x, POS.NOUN, nullSuffixArray));
        list.add(new StemmingRule(SUFFIX_zes, ENDING_z, POS.NOUN, nullSuffixArray));
        list.add(new StemmingRule(SUFFIX_ches, ENDING_ch, POS.NOUN, nullSuffixArray));
        list.add(new StemmingRule(SUFFIX_shes, ENDING_sh, POS.NOUN, nullSuffixArray));
        list.add(new StemmingRule(SUFFIX_men, ENDING_man, POS.NOUN, nullSuffixArray));
        list.add(new StemmingRule(SUFFIX_ies, ENDING_y, POS.NOUN, nullSuffixArray));
        ruleMapHidden.put(POS.NOUN, Collections.unmodifiableList(list));
        list = new ArrayList(8);
        list.add(new StemmingRule("s", ENDING_null, POS.VERB, nullSuffixArray));
        list.add(new StemmingRule(SUFFIX_ies, ENDING_y, POS.VERB, nullSuffixArray));
        list.add(new StemmingRule(SUFFIX_es, ENDING_e, POS.VERB, nullSuffixArray));
        list.add(new StemmingRule(SUFFIX_es, ENDING_null, POS.VERB, nullSuffixArray));
        list.add(new StemmingRule(SUFFIX_ed, ENDING_e, POS.VERB, nullSuffixArray));
        list.add(new StemmingRule(SUFFIX_ed, ENDING_null, POS.VERB, nullSuffixArray));
        list.add(new StemmingRule(SUFFIX_ing, ENDING_e, POS.VERB, nullSuffixArray));
        list.add(new StemmingRule(SUFFIX_ing, ENDING_null, POS.VERB, nullSuffixArray));
        ruleMapHidden.put(POS.VERB, Collections.unmodifiableList(list));
        list = new ArrayList(4);
        list.add(new StemmingRule(SUFFIX_er, ENDING_e, POS.ADJECTIVE, nullSuffixArray));
        list.add(new StemmingRule(SUFFIX_er, ENDING_null, POS.ADJECTIVE, nullSuffixArray));
        list.add(new StemmingRule(SUFFIX_est, ENDING_e, POS.ADJECTIVE, nullSuffixArray));
        list.add(new StemmingRule(SUFFIX_est, ENDING_null, POS.ADJECTIVE, nullSuffixArray));
        ruleMapHidden.put(POS.ADJECTIVE, Collections.unmodifiableList(list));
        ruleMapHidden.put(POS.ADVERB, Collections.emptyList());
        ruleMap = Collections.unmodifiableMap(ruleMapHidden);
    }
}

