/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jwi.morph;

import edu.mit.jwi.item.POS;
import edu.mit.jwi.morph.IStemmingRule;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StemmingRule
implements IStemmingRule {
    private final POS pos;
    private final String suffix;
    private final String ending;
    private final Set<String> ignoreSet;

    public StemmingRule(String suffix, String ending, POS pos, String ... ignore) {
        if (suffix == null) {
            throw new NullPointerException();
        }
        if (ending == null) {
            throw new NullPointerException();
        }
        if (pos == null) {
            throw new NullPointerException();
        }
        Set ignoreSet = null;
        if (ignore != null && ignore.length > 0) {
            ignoreSet = new HashSet(ignore.length);
            for (String avoidStr : ignore) {
                if (avoidStr == null) {
                    throw new NullPointerException();
                }
                if ((avoidStr = avoidStr.trim()).length() == 0) {
                    throw new IllegalArgumentException();
                }
                ignoreSet.add(avoidStr);
            }
            ignoreSet = Collections.unmodifiableSet(ignoreSet);
        } else {
            ignoreSet = Collections.emptySet();
        }
        suffix = suffix.trim();
        ending = ending.trim();
        if (suffix.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (ignoreSet.contains(suffix)) {
            throw new IllegalArgumentException();
        }
        this.pos = pos;
        this.suffix = suffix;
        this.ending = ending;
        this.ignoreSet = ignoreSet;
    }

    @Override
    public String getSuffix() {
        return this.suffix;
    }

    @Override
    public String getEnding() {
        return this.ending;
    }

    @Override
    public Set<String> getSuffixIgnoreSet() {
        return this.ignoreSet;
    }

    @Override
    public POS getPOS() {
        return this.pos;
    }

    @Override
    public String apply(String word) {
        return this.apply(word, null);
    }

    @Override
    public String apply(String word, String suffix) {
        if (!word.endsWith(this.getSuffix())) {
            return null;
        }
        for (String ignoreSuffix : this.getSuffixIgnoreSet()) {
            if (!word.endsWith(ignoreSuffix)) continue;
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int len = word.length() - this.getSuffix().length();
        for (int i = 0; i < len; ++i) {
            sb.append(word.charAt(i));
        }
        sb.append(this.getEnding());
        if (suffix != null) {
            sb.append(suffix.trim());
        }
        return sb.toString();
    }
}

