/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jwi.morph;

import edu.mit.jwi.IDictionary;
import edu.mit.jwi.item.IExceptionEntry;
import edu.mit.jwi.item.POS;
import edu.mit.jwi.morph.SimpleStemmer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordnetStemmer
extends SimpleStemmer {
    private final IDictionary dict;

    public WordnetStemmer(IDictionary dict) {
        if (dict == null) {
            throw new NullPointerException();
        }
        this.dict = dict;
    }

    public IDictionary getDictionary() {
        return this.dict;
    }

    @Override
    public List<String> findStems(String word, POS pos) {
        word = this.normalize(word);
        if (pos == null) {
            return super.findStems(word, null);
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        IExceptionEntry excEntry = this.dict.getExceptionEntry(word, pos);
        if (excEntry != null) {
            result.addAll(excEntry.getRootForms());
        }
        if (this.dict.getIndexWord(word, pos) != null) {
            result.add(word);
        }
        if (excEntry != null) {
            return new ArrayList<String>(result);
        }
        List<String> possibles = super.findStems(word, pos);
        Iterator<String> i = possibles.iterator();
        while (i.hasNext()) {
            if (i.next().trim().length() != 0) continue;
            i.remove();
        }
        for (String possible : possibles) {
            if (this.dict.getIndexWord(possible, pos) == null) continue;
            result.add(possible);
        }
        if (result.isEmpty()) {
            if (possibles.isEmpty()) {
                return Collections.emptyList();
            }
            return new ArrayList<String>(possibles);
        }
        return new ArrayList<String>(result);
    }
}

